// config: norepeat

#include "GetObjects.js"

function DoHistory()
{
	var objectpicker = moi.ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectionPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'HistoryPrompt' );
	moi.ui.showUI( 'HistoryOptions' );
	moi.ui.endUIUpdate();
	
	var commandDialog = moi.ui.commandDialog;
	
	while ( 1 )
	{
		if ( !commandDialog.waitForEvent() || commandDialog.event == 'done' )
			return;
			
		if ( commandDialog.event == 'enablehistory' )
		{
			objects.setProperty( 'updateWithHistory', true );
			return;
		}
		else if ( commandDialog.event == 'disablehistory' )
		{
			objects.setProperty( 'updateWithHistory', false );
			return;
		}
	}
}

DoHistory();
